<?php

function pa_add_admin_menu() {
    add_menu_page(
        'Precio Alternativo WooCommerce',
        'Precio Alternativo',
        'manage_options',
        'precio_alternativo',
        'pa_options_page',
        'dashicons-cart',
        20
    );
}
add_action('admin_menu', 'pa_add_admin_menu');

function pa_options_page() { 
    // Guardar opciones
    if (isset($_POST['pa_save_settings'])) {
        update_option('pa_discount_percentage', sanitize_text_field($_POST['pa_discount_percentage']));
        update_option('pa_installment_count', sanitize_text_field($_POST['pa_installment_count']));
        echo '<div class="updated"><p>Configuraciones guardadas.</p></div>';
    }

    // Obtener las opciones guardadas
    $discount_percentage = get_option('pa_discount_percentage', '20'); // Valor por defecto 20%
    $installment_count = get_option('pa_installment_count', '3'); // Valor por defecto 3

    ?>
    <div class="wrap">
        <h1>Precio Alternativo WooCommerce</h1>
        <form method="post" action="">
            <h2>Configuraciones</h2>
            <!-- Texto de bienvenida y descripción del plugin -->
            <p>Bienvenido al plugin <strong>Precio Alternativo WooCommerce</strong>. Este plugin te permite configurar precios alternativos para tus productos, como precios con descuento y en cuotas. Utiliza las configuraciones a continuación para ajustar el porcentaje de descuento y la cantidad de cuotas que deseas aplicar globalmente. Si no configuras nada, se usarán los valores por defecto.</p>
            
            <table class="form-table">
                <tr>
                    <th scope="row"><label for="pa_discount_percentage">Porcentaje de Descuento (%)</label></th>
                    <td><input type="number" id="pa_discount_percentage" name="pa_discount_percentage" value="<?php echo esc_attr($discount_percentage); ?>" /></td>
                </tr>
                <tr>
                    <th scope="row"><label for="pa_installment_count">Número de Cuotas</label></th>
                    <td><input type="number" id="pa_installment_count" name="pa_installment_count" value="<?php echo esc_attr($installment_count); ?>" /></td>
                </tr>
            </table>
            <?php submit_button('Guardar Configuraciones', 'primary', 'pa_save_settings'); ?>
        </form>

        <h2>Shortcodes Disponibles</h2>
        <ul>
            <li><code id="shortcode_contado">[mostrar_precio_contado]</code> <button onclick="copyToClipboard('#shortcode_contado')">Copiar</button></li>
            <li><code id="shortcode_cuota">[mostrar_precio_cuota]</code> <button onclick="copyToClipboard('#shortcode_cuota')">Copiar</button></li>
            <li><code id="shortcode_contado_rebajado">[mostrar_precio_contado_rebajado]</code> <button onclick="copyToClipboard('#shortcode_contado_rebajado')">Copiar</button></li>
            <li><code id="shortcode_cuota_rebajado">[mostrar_precio_cuota_rebajado]</code> <button onclick="copyToClipboard('#shortcode_cuota_rebajado')">Copiar</button></li>
        </ul>
        <script>
            function copyToClipboard(element) {
                var $temp = document.createElement("input");
                document.body.appendChild($temp);
                $temp.value = document.querySelector(element).textContent;
                $temp.select();
                document.execCommand("copy");
                document.body.removeChild($temp);
                alert('Shortcode copiado al portapapeles.');
            }
        </script>

        <!-- Mensaje de agradecimiento y enlace a tu web -->
        <div style="margin-top: 20px; border-top: 1px solid #ccc; padding-top: 10px;">
            <p>Gracias por usar el plugin <strong>Precio Alternativo WooCommerce</strong>. Visita <a href="https://fersosa.com/" target="_blank">fersosa.com</a> para más información y otros proyectos.</p>
        </div>
    </div>
    <?php
}
?>
